function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 256);

T = World_Economy_Cartel_nonopec_shocks.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(117) = exp(y(22))*exp(y(25))*T(91);
T(118) = T(33)+T(32)*y(20)*(-(exp(y(22))*T(24)*exp(params(5)*(-y(46)))));
T(119) = T(32)*y(18)*(-(T(24)*exp(y(22))*(-exp(y(11)-y(46)))))+T(32)*y(20)*(-(exp(y(22))*T(24)*exp(params(5)*(-y(46)))*(-params(5))));
T(120) = (-(T(23)*exp(y(32)-y(96))*exp(y(85))));
T(121) = y(62)*T(120);
T(122) = (-(exp(y(6))*exp((-y(45)))*exp(y(10))));
T(123) = y(70)*T(109)+y(66)*T(110);
T(124) = T(38)+params(22)*y(101)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32))+T(48);
T(125) = y(71)*T(105)+y(67)*T(106)+y(59)*exp(y(6))*params(6)*(-params(5))*params(5)*exp(params(5)*(y(10)-y(45)));
T(126) = (-(exp(y(6))*(-(exp((-y(45)))*exp(y(10))))));
T(127) = T(36)+T(42)+params(22)*y(101)*exp(y(27))*params(6)*params(5)*params(5)*exp(params(5)*(y(31)-y(95)));
T(128) = exp(y(22))*exp(y(11)-y(46))+y(34)*(-exp(y(11)-y(46)));
T(129) = T(32)*y(20)*T(24)*params(6)*params(5)*exp(params(5)*(-y(46)))*(params(5)-1)*exp(y(11)*(params(5)-1))+T(32)*y(18)*(-(T(24)*(T(128)-params(6)*params(5)*exp(params(5)*(y(11)-y(46))))));
T(130) = T(32)*y(18)*(-(T(24)*(T(111)-params(6)*(-params(5))*params(5)*exp(params(5)*(y(11)-y(46))))))+T(32)*y(20)*T(24)*params(6)*params(5)*exp(params(5)*(-y(46)))*(-params(5))*(params(5)-1)*exp(y(11)*(params(5)-1));
T(131) = T(23)*params(6)*params(5)*exp(params(5)*(-y(96)))*(params(5)-1)*(params(5)-1)*exp(y(32)*(params(5)-1));
T(132) = (-(T(23)*(T(45)-params(6)*params(5)*params(5)*exp(params(5)*(y(32)-y(96))))));
T(133) = y(62)*T(132);
T(134) = T(32)*y(18)*(-(T(24)*(1-exp(y(11)-y(46)))))+T(32)*y(20)*T(24)*exp(params(5)*(-y(46)));
T(135) = T(32)*y(18)*(-(T(24)*exp(y(11)-y(46))))+T(32)*y(20)*T(24)*exp(params(5)*(-y(46)))*(-params(5));
T(136) = T(8)*getPowerDeriv(T(8),T(13),2);
T(137) = T(8)*T(136);
T(138) = T(49)+T(137);
T(139) = T(8)*getPowerDeriv(T(8),T(1),2);
T(140) = T(8)*T(139);
T(141) = T(50)+T(140);
T(142) = params(11)*T(141);
T(143) = getPowerDeriv(T(9),T(10),2);
T(144) = exp(y(88))*getPowerDeriv(exp(y(88)),T(1),1);
T(145) = getPowerDeriv(T(63),T(10),2);
T(146) = exp(y(37))*getPowerDeriv(exp(y(37)),T(11),2);
T(147) = exp(y(37))*T(146);
T(148) = T(52)+T(147);
T(149) = y(57)*(-(T(19)*T(16)*T(53)*T(81)+T(5)*T(19)*T(53)*T(83)))+y(56)*(-(T(17)*T(3)*T(54)*T(83)+T(3)*T(16)*T(54)*T(85)));
T(150) = (-(T(5)*T(19)*T(16)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))));
T(151) = (-(T(17)*T(3)*T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))));
T(152) = y(57)*T(150)+y(56)*T(151);
T(153) = exp(y(89))*getPowerDeriv(exp(y(89)),T(11),1);
T(154) = (1-params(11))*(1-params(3))*exp(T(1)*y(94))*T(153);
T(155) = (-(T(56)*(T(71)*T(70)*(1-params(11))*params(3)*exp(T(1)*y(94))*T(153)+T(73)*T(68)*(1-params(11))*params(3)*exp(T(1)*y(94))*T(153))));
T(156) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(157) = T(5)*T(156);
T(158) = T(2)*T(87)*T(157);
T(159) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(160) = (-(T(5)*(T(16)*T(53)*T(159)+T(19)*T(53)*T(82)*T(157))));
T(161) = T(16)*T(54)*T(156)+T(3)*T(54)*T(82)*T(157);
T(162) = getPowerDeriv(T(6),T(13),2);
T(163) = T(82)*T(81)*T(156)+T(3)*T(81)*T(157)*T(162);
T(164) = T(15)*T(16)*T(156)+T(3)*T(15)*T(82)*T(157);
T(165) = getPowerDeriv(T(6),T(1),2);
T(166) = T(2)*(T(87)*T(81)*T(156)+T(3)*T(81)*T(157)*T(165));
T(167) = (-(exp(y(39)*(1-params(3)))*T(1)*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))));
T(168) = T(16)*T(97)*T(159)+T(19)*T(97)*T(82)*T(157);
T(169) = T(16)*T(98)*T(156)+T(3)*T(98)*T(82)*T(157);
T(170) = T(20)*getPowerDeriv(T(20),params(3),2);
T(171) = T(20)*T(170);
T(172) = T(57)+T(171);
T(173) = getPowerDeriv(T(59),T(1),2);
T(174) = T(55)*(T(60)*T(56)*T(172)+T(56)*T(57)*T(56)*T(57)*T(173));
T(175) = getPowerDeriv(T(59),T(13),2);
T(176) = T(69)*T(56)*T(172)+T(56)*T(57)*T(56)*T(57)*T(175);
T(177) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(178) = T(20)*T(177);
T(179) = T(73)+T(178);
T(180) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(181) = (-(params(9)*T(180)/(1+params(8))));
T(182) = getPowerDeriv(T(27),(-params(14)),1);
T(183) = T(181)*T(182);
T(184) = (-((-(params(1)*T(78)*T(183)))/(T(28)*T(28))));
T(185) = (-((-(params(1)*T(91)*T(183)))/(T(28)*T(28))));
T(186) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(187) = T(4)*T(186);
T(188) = T(75)+T(187);
T(189) = (-(params(9)*T(188)/(1+params(8))));
T(190) = getPowerDeriv(T(25),(-params(14)),2);
T(191) = T(77)*T(189)+T(76)*T(76)*T(190);
T(192) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(193) = T(4)*T(192);
T(194) = T(81)+T(193);
T(195) = T(82)*T(3)*T(194)+T(3)*T(81)*T(3)*T(81)*T(162);
T(196) = (-(T(81)*T(19)*T(18)*T(83)+T(16)*T(18)*T(19)*T(194)+T(81)*T(19)*T(18)*T(83)+T(5)*T(19)*T(18)*T(195)));
T(197) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(198) = T(4)*T(197);
T(199) = T(85)+T(198);
T(200) = (-(T(3)*T(15)*T(83)*T(85)+T(17)*T(3)*T(15)*T(195)+T(3)*T(15)*T(83)*T(85)+T(3)*T(15)*T(16)*T(199)));
T(201) = T(2)*(T(87)*T(3)*T(194)+T(3)*T(81)*T(3)*T(81)*T(165));
T(202) = T(26)*T(26)*T(26)*T(26);
T(203) = (-((T(26)*T(26)*(-(T(90)*T(191)))-(-(T(78)*T(90)))*(T(26)*T(78)+T(26)*T(78)))/T(202)));
T(204) = exp(y(40))*T(76)*T(190);
T(205) = T(26)*T(26)*(-(T(90)*T(204)))-(-(T(90)*T(91)))*(T(26)*T(78)+T(26)*T(78));
T(206) = (-(T(81)*T(19)*T(16)*T(97)+T(5)*T(19)*T(83)*T(97)));
T(207) = y(57)*T(206);
T(208) = y(56)*(-(T(85)*T(3)*T(16)*T(98)+T(17)*T(3)*T(83)*T(98)));
T(209) = T(3)*T(81)*T(87)*T(99);
T(210) = T(78)*T(103);
T(211) = exp(y(90))*getPowerDeriv(exp(y(90)),1-params(3),1);
T(212) = T(55)*(T(60)*T(57)*T(211)+T(56)*T(57)*T(173)*T(58)*T(211));
T(213) = exp(y(90))*getPowerDeriv(exp(y(90)),(-params(3)),1);
T(214) = T(69)*T(57)*T(211)+T(56)*T(57)*T(175)*T(58)*T(211);
T(215) = exp(y(90))*getPowerDeriv(exp(y(90)),1+params(8),1);
T(216) = (-(params(9)*T(215)/(1+params(8))));
T(217) = getPowerDeriv(T(89),(-params(14)),1);
T(218) = params(1)*T(216)*T(217);
T(219) = (-((-(params(1)*T(78)*exp(y(15))*T(182)))/(T(28)*T(28))));
T(220) = (-((-(params(1)*T(91)*exp(y(15))*T(182)))/(T(28)*T(28))));
T(221) = T(76)*exp(y(40))*T(190);
T(222) = T(26)*T(91)+T(26)*T(91);
T(223) = (-((T(26)*T(26)*(-(T(90)*T(221)))-(-(T(78)*T(90)))*T(222))/T(202)));
T(224) = T(91)+exp(y(40))*exp(y(40))*T(190);
T(225) = exp(y(42))*getPowerDeriv(exp(y(42)),T(22),2);
T(226) = exp(y(42))*T(225);
T(227) = T(93)+T(226);
T(228) = (-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(229) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(230) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(44));
T(231) = T(56)*T(57)*T(60)*(1-params(11))*T(1)*exp(T(1)*y(94));
T(232) = T(66)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(94));
T(233) = T(57)*T(68)*T(232)+T(58)*T(70)*T(232);
T(234) = T(71)*T(70)*T(66)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(94))+T(73)*T(68)*T(66)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(94));
T(235) = getPowerDeriv(exp(y(53)-y(45)),params(5)-1,2);
T(236) = (-(exp(y(25))*params(6)*(exp(y(53)-y(45))*T(102)+(-exp(y(53)-y(45)))*(-exp(y(53)-y(45)))*T(235))));
T(237) = y(71)*T(122)+y(67)*T(126)+y(59)*exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(45)))*(-params(5));
T(238) = (-(exp(y(25))*params(6)*((-exp(y(53)-y(45)))*T(102)+exp(y(53)-y(45))*(-exp(y(53)-y(45)))*T(235))));
T(239) = params(22)*y(101)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(95)))*(-params(5))+params(22)*y(104)*(-(exp(y(27))*(-(exp(y(31))*(-exp((-y(95))))))))+params(22)*y(108)*(-(exp(y(27))*exp(y(31))*(-exp((-y(95))))));
T(240) = params(22)*y(108)*(-(exp(y(27))*exp(y(31))*(-exp((-y(95))))))+params(22)*y(104)*(-(exp(y(27))*(-(exp(y(31))*(-exp((-y(95))))))))+params(22)*y(101)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(95)))*(-params(5));
T(241) = T(24)*exp(y(11)*(params(5)-1))*params(6)*params(5)*(-params(5))*exp(params(5)*(-y(46)))*(-params(5))-(exp(y(22))-y(34))*T(24)*(-params(5))*exp(params(5)*(-y(46)))*(-params(5));
T(242) = T(32)*y(18)*(-(T(24)*(T(128)-params(6)*(-params(5))*exp(params(5)*(y(11)-y(46)))*(-params(5)))))+T(32)*y(20)*T(241);
T(243) = params(22)*y(103)*(-(exp(y(32)-y(96))*exp(y(28))))+params(22)*y(107)*(-(exp(y(28))*(-exp(y(32)-y(96)))));
T(244) = T(23)*(params(5)-1)*exp(y(32)*(params(5)-1))*params(6)*params(5)*exp(params(5)*(-y(96)))*(-params(5));
T(245) = (-(T(23)*(exp(y(85))*(-exp(y(32)-y(96)))+exp(y(32)-y(96))*y(86)-params(6)*params(5)*exp(params(5)*(y(32)-y(96)))*(-params(5)))));
T(246) = y(65)*T(244)+y(62)*T(245);
T(247) = (-(T(23)*(exp(y(85))*(-exp(y(32)-y(96)))+exp(y(32)-y(96))*y(86)-params(6)*exp(params(5)*(y(32)-y(96)))*(-params(5)))));
T(248) = T(23)*exp(y(32)*(params(5)-1))*params(6)*params(5)*exp(params(5)*(-y(96)))*(-params(5))-(exp(y(85))-y(86))*T(23)*exp(params(5)*(-y(96)))*(-params(5));
T(249) = (-exp(y(53)-y(45)))*T(102)+(-exp(y(53)-y(45)))*exp(y(53)-y(45))*T(235);
T(250) = (-(exp(y(25))*params(6)*T(249)));
T(251) = (-(exp(y(25))*params(6)*(exp(y(53)-y(45))*T(102)+exp(y(53)-y(45))*exp(y(53)-y(45))*T(235))));
T(252) = T(32)*(-(T(24)*exp(y(22))*exp(y(11)-y(46))));
T(253) = params(22)*(-(exp(y(28))*(-exp(y(32)-y(96)))));
T(254) = params(22)*(-(exp(y(27))*(-(exp((-y(95)))*exp(y(31))))));
T(255) = params(22)*(-(exp(y(32)-y(96))*exp(y(28))));
T(256) = params(22)*(-(exp(y(27))*exp((-y(95)))*exp(y(31))));

end
